#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Day 405Mod01.fsh  by   jeyko  
//https://www.shadertoy.com/view/ttVcRt
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define slices 180.

const float disp = 0.4;

const float eps = 0.01;

const float width = 0.00035;

float fun(float p, float py){
    
    float f = sin(p + iTime + cos(py*0.05 + sin(p))*0.7)*sin(py*0.1 + iTime*0.2);
    
    //f = cos(p*0.4- iTime + py)*cos(p*0.4*sin(p) + iTime)*(sin(py + iTime));
    //f = sin(p*0.5 + sin(py))*(cos(py*0.1 + iTime));
    
    f *= mix(
        smoothstep(0.,1.,abs(p + sin(py)*0.1)),
        smoothstep(0.,1.,abs(p + sin(py*0.3 + iTime)*0.1)),
        0.5 + sin(iTime*0.4 )*0.5
        );
    
    return f*disp;
}



float graph(float y, float fn0, float fn1, float pixelSize){
  return smoothstep(pixelSize ,0., 
                    abs(fn0-y)/length(vec2((fn1-fn0)/eps,1.))- width);
}
float graphNoAbs(float y, float fn0, float fn1, float pixelSize){
  return smoothstep(pixelSize,0., 
                    -(fn0-y)/length(vec2((fn1-fn0)/eps,1.)) - width);
}



//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    vec2 uv = (fragCoord - 0.5*iResolution.xy)/iResolution.y;
    
    vec3 col = vec3(0);

    
    float pixelSize = dFdx(uv.x)*1.25;
    
    for(float i = 0.; i < slices; i++ ){
        vec2 p = uv + vec2(0.,i/slices*2. - 0.8);
        
        //float funIdx = p.x*4. + sin(p.y*i/slices*2. + iTime)*1.5*sin(p.x - iTime);
        float funIdx = p.x;
        
        col -= graphNoAbs( p.y + 0.0, fun(funIdx,i), fun(funIdx+eps,i), pixelSize);
        col = max(col,0.);
        col = mix(col, vec3(1), graph( p.y, fun(funIdx,i), fun(funIdx+eps,i), pixelSize ));
        
    }
    
    
    col = 1. - col;
    
    
    col = pow(col,vec3(0.4545));
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

